import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a new figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Define colors for statuses
colors = {'clear': 'green', 'supporting': 'red'}

# Define block positions and sizes
block_width, block_height = 1, 0.5
table_height = 0.3
hand_radius = 0.2

# Draw the table
table = patches.Rectangle((0, 0), 5, table_height, linewidth=1, edgecolor='black', facecolor='gray')
ax.add_patch(table)

# Draw the blocks
blocks = {
    'a': (0.5, table_height, 'supporting'),  # on table
    'b': (2.5, table_height, 'supporting'),  # on table
    'c': (2.5, table_height + block_height, 'clear'),  # on block b
    'd': (0.5, table_height + block_height, 'clear'),  # on block a
    'e': (4.5, table_height, 'clear')  # on table
}

for block, (x, y, status) in blocks.items():
    rect = patches.Rectangle((x, y), block_width, block_height, linewidth=1,
                             edgecolor='black', facecolor=colors[status])
    ax.add_patch(rect)
    ax.text(x + block_width / 2, y + block_height / 2, f'{block}\n{status}',
            horizontalalignment='center', verticalalignment='center', fontsize=8, color='white')

# Draw the hand
hand = patches.Circle((2.5, table_height + 2 * block_height + hand_radius), hand_radius,
                      linewidth=1, edgecolor='black', facecolor='blue')
ax.add_patch(hand)
ax.text(2.5, table_height + 2 * block_height + hand_radius, 'hand\nempty',
        horizontalalignment='center', verticalalignment='center', fontsize=8, color='white')

# Create a legend
legend_patches = [
    patches.Patch(color='green', label='Clear'),
    patches.Patch(color='red', label='Supporting')
]
plt.legend(handles=legend_patches, loc='upper right', bbox_to_anchor=(1.15, 1))

# Set limits and aspect
ax.set_xlim(-1, 6)
ax.set_ylim(-0.5, 3)
ax.set_aspect('equal')
ax.axis('off')

# Save the figure
plt.savefig('blocksworld/one_shot/ini_diagram_code/attempts/attempt_37.png', bbox_inches='tight')
plt.show()